SUBROUTINE ordena_array(array, n)
    !Ordena um array numérico em ordem crescente
    
    IMPLICIT NONE

    DOUBLE PRECISION, DIMENSION(n) :: array !Array a ser ordenado
    INTEGER :: n, i, j !Dimensão n do array e variáveis auxiliares
    DOUBLE PRECISION :: aux !Variável auxiliar
    
    !Laço que passa por todas as posições do array
    DO i = 1, (n - 1)

        !Laço que compara o número em array(i) e na posição seguinte, array(j) (j = i + 1)
        DO j = (i + 1), n
            
            IF (array(j) < array(i)) THEN
                
                !Troca os valores nos índices i e j do array, caso array(i) > array(j)
                aux = array(i)
                array(i) = array(j)
                array(j) = aux
                
            END IF

        END DO

    END DO

END SUBROUTINE ordena_array

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

SUBROUTINE encontra_posicao(x, abscissas, n, retorno)
    !Encontra um índice em um intervalo de abscissas (array de dimensão n) que corresponde ao valor (dentro do array) mais próximo de um x dado.
    !Retorna 0 caso x < abscissas(1), n caso x > abscissas(n) ou o índice propriamente dito, entre 1 e n-1

    IMPLICIT NONE

    DOUBLE PRECISION, DIMENSION(n), INTENT(IN) :: abscissas !Array de abscissas
    DOUBLE PRECISION :: x !Valor procurado
    INTEGER :: atual, anterior, medio, n, retorno !Índices atual, anterior e médio, dimensão do array abscissas e retorno do programa conforme estabelecido no enunciado do exercício

    !Verifica se x < x1 e retorna 0 no caso afirmativo
    IF (x < abscissas(1)) THEN
        retorno = 0

    !Verifica se x > xn e retorna n no caso afirmativo
    ELSE IF (x > abscissas(n)) THEN
        retorno = n

    !Encontra um intervalo x1 <= x <= xn e retorna o índice i do valor do array abscissas mais próximo de x
    ELSE

        atual = 2 !Começa a partir do segundo x das abscissas
        anterior = 1 !Índice anterior (metade do atual)

        DO WHILE ((atual * 2) <= n .AND. abscissas(anterior) < x)

            anterior = atual
            atual = atual * 2 !Caçada corre pelo array procurando entre xi sendo i sempre o dobro do anterior, para economizar tempo e memória

        END DO
        
        !Encontrado um intervalo que contenha o x procurado, refina esse intervalo pelo método da bissecção
        DO WHILE (atual .NE. (anterior + 1))
        
            medio = anterior + ABS(atual - anterior) / 2
            
            IF (abscissas(medio) < x) THEN
                anterior = medio
                
            ELSE
                atual = medio
        
            END IF
        
        END DO
        
        !Checa e retorna qual o índice (atual ou anterior) contém o xi mais próximo do x desejado
        IF (ABS(abscissas(atual) - x) < ABS(abscissas(anterior) - x)) THEN
            retorno = atual
            
        ELSE
            retorno = anterior
            
        END IF

    END IF

END SUBROUTINE encontra_posicao

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

PROGRAM procuravalor
    !Encontra a posição de um valor x qualquer em uma tabela de abcissas dada.
    
    IMPLICIT NONE
    
    DOUBLE PRECISION, DIMENSION(10) :: abscissas
    DOUBLE PRECISION :: x
    INTEGER :: retorno
    
    !Criando o array abscissas    
    abscissas = (/3268.0283, 3981.0708, 4849.6929, 5907.8379, 1218.1881, 2202.2019, 28651.2012, 34902.5508, 42517.8711, 10680.0088/)
    
    !Ordenando array abscissas em ordem crescente
    CALL ordena_array(abscissas, 10)

    !Para um x menor que o primeiro valor de abscissas
    x = 1000.
    PRINT *,
    CALL encontra_posicao(x, abscissas, 10, retorno)
    PRINT *, "Para um valor de x =", x
    PRINT *, "A subrotina retorna o valor", retorno
    
    !Para um x entre o primeiro e o último valor de abscissas
    x = 10000.
    PRINT *,
    CALL encontra_posicao(x, abscissas, 10, retorno) !DANDO LOOP INFINITO
    PRINT *, "Para um valor de x =", x
    PRINT *, "A subrotina retorna o índice", retorno
    PRINT *, "Que corresponde ao valor", abscissas(retorno), "do array fornecido"
    
    !Para um x maior que o último valor de abscissas
    x = 100000.
    PRINT *,
    CALL encontra_posicao(x, abscissas, 10, retorno)
    PRINT *, "Para um valor de x =", x
    PRINT *, "A subrotina retorna o valor", retorno
    PRINT *, "Que corresponde ao tamanho do array fornecido"

END PROGRAM procuravalor
